﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class SppMaterial : MonoBehaviour {
    public static Dictionary<string, Material> sharedMaterials = new Dictionary<string, Material>();
    private static Shader currentShaderOpaque = Shader.Find("Specular");
    private static Shader currentShaderTransparent = Shader.Find("Transparent/Diffuse");
    private static Texture2D matcap = null;

    public static void Init()
    {
        sharedMaterials.Clear();
            switch (SppConfig.renderMode)
            {
                case SppConfig.RenderMode.MatCap:
                    currentShaderOpaque = Shader.Find("SPPV/MatCap");
                    currentShaderTransparent = Shader.Find("Transparent/Diffuse");
                break;
                case SppConfig.RenderMode.Legacy:
                    currentShaderOpaque = Shader.Find("Specular");
                    currentShaderTransparent = Shader.Find("Transparent/Diffuse");
                break;
                case SppConfig.RenderMode.PBR:
                    currentShaderOpaque = Shader.Find("Standard"); // Wird erst über ConvertMaterialToPBR angepasst
                    currentShaderTransparent = Shader.Find("Standard"); // Wird erst über ConvertMaterialToPBR angepasst
                break;
            }
            matcap = (Texture2D)Resources.Load("Textures/matcap");


    }

    public static void CleanUp()
    {
        Resources.UnloadUnusedAssets();
    }

    public static Material GetMaterial(string materialKey, Color color) {
        if (sharedMaterials.ContainsKey(materialKey)) {
            return sharedMaterials[materialKey];
        } else {
            Material newMAT;
            if (color.a < 1f)
            {
                newMAT = new Material(currentShaderTransparent);
                if (SppConfig.renderMode == SppConfig.RenderMode.PBR)
                {
                    PBRUtils.ChangeRenderMode(newMAT, (PBRUtils.BlendMode)3);
                    newMAT.SetFloat("_Glossiness", 0f);
                    newMAT.SetFloat("_Metallic", 0f);
                }

            } else {
                newMAT = new Material(currentShaderOpaque);
                if (SppConfig.renderMode == SppConfig.RenderMode.PBR)
                {
                    newMAT.SetFloat("_Glossiness", 0.6f);
                    newMAT.SetFloat("_Metallic", 1f);
                }
                else if (SppConfig.renderMode == SppConfig.RenderMode.MatCap)
                {
                    newMAT.SetTexture("_MatCap", matcap);
                    newMAT.SetFloat("_Shininess", 0.2f);
                }

            }
            newMAT.name = materialKey;
            newMAT.color = color;
            sharedMaterials.Add(materialKey, newMAT);
            return sharedMaterials[materialKey];
        }
    }

    public static Shader GetTransparentShader()
    {
        return currentShaderTransparent;
    }

    public static Shader GetOpaqueShader()
    {
        return currentShaderOpaque;
    }
}
